/*
 * @file ExInvalidFieldName.hpp
 *
 * Copyright 2025 Sebastien Devaux. All rights reserved.
 * Use is subject to license terms.
 *
 * $Id$
 * $Date$
 */
#ifndef __simdeck_ExInvalidFieldName_HPP__
#define __simdeck_ExInvalidFieldName_HPP__
#include "simdeck/Exception.hpp"
#include "Smp/InvalidFieldName.h"

namespace simdeck {

/**
 *
 */
class ExInvalidFieldName: public Exception, virtual public Smp::InvalidFieldName {
    typedef Exception Parent;
public:
    /**
     * Default constructor.
     */
    ExInvalidFieldName(const Smp::IObject* sender, Smp::String8 invalidName);
    /**
     * Destructor.
     */
    virtual ~ExInvalidFieldName();
    // Smp::InvalidFieldName implementation
    Smp::String8 GetFieldName() const noexcept override;

private:
    std::string _invalidName;

};

} // namespace simdeck
#endif // __simdeck_ExInvalidFieldName_HPP__
