#ifndef SXEVAL_OPERATIONS_SINE_HPP
#define SXEVAL_OPERATIONS_SINE_HPP

#include "sxeval/AOperation.hpp"
#include <cmath>


/* DEFINITIONS */

namespace sxeval {
namespace operations {

template <typename T>
class Operations;

template <typename T>
class Sine : public AOperation<T> {
public:
    void execute() override;

protected:
    static constexpr const char *KEY = "sin";
    static constexpr const int ARITY_MIN = 1;
    static constexpr const int ARITY_MAX = 1;

    inline Sine(const std::vector<AInstruction<T>*>& args) :
        AOperation<T>(args) {}

    friend class Operations<T>;

};

} /* namespace operations */
} /* namespace sxeval */


/* IMPLEMENTATIONS */

template <typename T>
void sxeval::operations::Sine<T>::execute() {
    this->_result = static_cast<T>(std::sin(this->_args.front()->getResult()));
}

#endif /* SXEVAL_OPERATIONS_SINE_HPP */
