#ifndef SXEVAL_OPERATIONS_FLOOR_HPP
#define SXEVAL_OPERATIONS_FLOOR_HPP

#include "sxeval/AOperation.hpp"
#include <cmath>


/* DEFINITIONS */

namespace sxeval {
namespace operations {

template <typename T>
class Floor : public AOperation<T> {
public:
    static constexpr const char* KEY = "floor";
    static constexpr const int ARITY_MIN = 1;
    static constexpr const int ARITY_MAX = 1;

    inline Floor(const std::vector<IInstruction<T>*>& args) :
        AOperation<T>(args) {}

    void execute() override;

    inline std::string toString() const override { return KEY; }

};

} /* namespace operations */
} /* namespace sxeval */


/* IMPLEMENTATIONS */

template <typename T>
constexpr const char* sxeval::operations::Floor<T>::KEY;

template <typename T>
void sxeval::operations::Floor<T>::execute() {
    this->_result = static_cast<T>(std::floor(this->_args.front().get()));
}

#endif /* SXEVAL_OPERATIONS_FLOOR_HPP */
