#ifndef __ABS_TEST_H__
#define __ABS_TEST_H__
#include <iostream>
#include <string>
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/plugin/TestPlugIn.h>

// defines variable to avoid undefined macro warnings.
// theses defines are created by testdef2cppunitdecl.h and dynamically included
// set default CPPUNIT_TEST macro to avoid warning on context variable
#ifndef __ABS_TEST_SUITE_CPPUNIT_DECL
#define __ABS_TEST_SUITE_CPPUNIT_DECL CPPUNIT_TEST(noTest);
#endif

#define ABS_TEST_SUITE_BEGIN(testSuiteName, ...) class Test##testSuiteName; \
    typedef Test##testSuiteName DefaultTestSuiteClass; \
    class Test##testSuiteName: public CppUnit::TestFixture , ##__VA_ARGS__ {\
        const char* __testSuiteNameStr = #testSuiteName;

#define ABS_TEST_SUITE_END CPPUNIT_TEST_SUITE(DefaultTestSuiteClass); \
__ABS_TEST_SUITE_CPPUNIT_DECL \
CPPUNIT_TEST_SUITE_END(); \
}; \
CPPUNIT_TEST_SUITE_REGISTRATION(DefaultTestSuiteClass);

#define ABS_TEST_CASE_BEGIN(testCaseName) \
   void test##testCaseName () { \
        std::string _abs_test_case_name = std::string(__testSuiteNameStr) + std::string("_" #testCaseName); \
        std::cout << std::endl << "ABS_TEST_CASE_START(" \
            << _abs_test_case_name << ")" << std::endl;

#define ABS_TEST_CONDITIONAL_CASE_BEGIN(condition,testCaseName) ABS_TEST_CASE_BEGIN(testCaseName)
#define ABS_TEST_DESCR(...)

#define ABS_TEST_CASE_END \
        std::cout << "ABS_TEST_CASE_COMPLETED(" << _abs_test_case_name << ")" << std::endl; \
    }

#define ABS_TEST_CASE_REQ(req) \
        std::cout << "ABS_TEST_CASE_REQ(" \
            << #req << ")" << std::endl;

#endif // __ABS_TEST_H__
