# ---------------------------------------------------------------------
# Java build rules
# ---------------------------------------------------------------------

# default compiler commands
PATH_SEP?=$(if $(ISWINDOWS),;,:)
ifeq ($(SYSNAME),Android_)
JC?=ecj
JAVA?=dalvikvm
JAR?=dx
TARGET_EXT=dex
else
JAVA?=java
JAR?=jar
JC?=javac
JDB?=jdb
TARGET_EXT=jar
endif

# ---------------------------------------------------------------------
# Compilation flags by compilation modes
# ---------------------------------------------------------------------
ifeq ($(MODE),debug)
# debugging symbols
	JFLAGS+= -g
else
# no debbugging symbol
	JFLAGS+= -g:none
endif

# Main target definition
ifeq ($(APPNAME),$(MODNAME))
TARGET=$(DOMAIN).$(APPNAME)-$(VERSION).$(TARGET_EXT)
else
TARGET=$(DOMAIN).$(APPNAME).$(MODNAME)-$(VERSION).$(TARGET_EXT)
endif
TARGETDIR=$(TRDIR)/lib
TARGETFILE=$(TARGETDIR)/$(TARGET)

# Jar preparation directory
JARIMGDIR:=$(OBJDIR)/jar
# Default dir to recieve generated java code
JGENSRCDIR:=$(OBJDIR)/gjava

# Java default settings
JARLIBS:=$(foreach entry,$(USEJAR),$(ABS_CACHE)/noarch/$(call getLibNameFromVersioned,$(entry))-$(call getLibVersionFromVersioned,$(entry)).jar)
JARDEPS:=$(foreach entry,$(USEJAR),$(ABS_CACHE)/noarch/$(call getLibNameFromVersioned,$(entry))/$(call getLibVersionFromVersioned,$(entry))/pck.jar)
JCLASSES:=$(patsubst src/%.java,$(JARIMGDIR)/%.class,$(filter %.java, $(SRCFILES)))
CLASSPATH:=$(subst $(_space_),:,$(JARLIBS)):$(patsubst $(TARGETDIR)/$(DOMAIN).$(APPNAME).$(APPNAME).%,$(TARGETDIR)/$(DOMAIN).$(APPNAME).%,$(patsubst %,$(TARGETDIR)/$(DOMAIN).$(APPNAME).%-$(VERSION).jar,$(USEJMOD)))
ifeq ($(ISWINDOWS),true)
CLASSPATH:=$(shell cygpath -mp $(CLASSPATH))
endif
ifeq ($(ISWINDOWS),true)
JFLAGS+=-cp "$(CLASSPATH)" -d `cygpath -m $(JARIMGDIR)`
JCFLAGS:=$(JFLAGS) -sourcepath "src;$(shell cygpath -m $(JARIMGDIR));$(shell cygpath -m $(JGENSRCDIR))"
else
JFLAGS+=-cp ".null:$(CLASSPATH)" -d $(JARIMGDIR)
JCFLAGS:=$(JFLAGS) -sourcepath "src:$(JARIMGDIR):$(JGENSRCDIR)"
endif
RESFILES=$(patsubst src/%,$(JARIMGDIR)/%,$(filter-out %.java src/test/%,$(SRCFILES)))

JAREXTLIBLINKS:=$(foreach entry,$(USEJAR),$(NA_EXTLIBDIR)/$(call getLibNameFromVersioned,$(entry))-$(call getLibVersionFromVersioned,$(entry)).jar)

$(NA_EXTLIBDIR)/%.jar:
	@mkdir -p $(@D)
	@ln -sf $(ABS_CACHE)/noarch/$(@F) $@

# ---------------------------------------------------------------------
# Default target : build target file
# ---------------------------------------------------------------------
TARGETFILES+=$(TARGETFILE)

# ---------------------------------------------------------------------
# Main transformation rules
# ---------------------------------------------------------------------
# Java file compilation
$(JARIMGDIR)/%.class: src/%.java
	@$(ABS_PRINT_info) "Compiling $< ..."
	@mkdir -p $(JARIMGDIR)
	@$(call writeToBuildLogs,$(JC) $(JCFLAGS) $<)
	@$(JC) $(JCFLAGS) $(if $(ISWINDOWS),`cygpath -m $<`,$<) || ( echo 'Failed: JFLAGS=$(JCFLAGS)' ; exit 1 )

# Resource file copy
$(JARIMGDIR)/%: src/%
	@$(ABS_PRINT_info) "Installing resource $< ..."
	@mkdir -p $(@D)
	@cp $< $@

# external dependancies and module dependancies.
.PRECIOUS: $(JARLIBS)

$(JCLASSES): $(JARDEPS) $(patsubst %,$(TARGETDIR)/$(DOMAIN).$(APPNAME).%-$(VERSION).jar,$(USEJMOD))

$(OBJDIR)/$(MODNAME).Manifest: $(JCLASSES)
	@$(ABS_PRINT_info) "Creating manifest file..."
	@mkdir -p $(@D)
	@echo "Main-Class: $(MAINCLASS)" > $@
	@echo "Implementation-Version: $(VERSION)-$(REVISION)" >> $@
	@echo "Implementation-Vendor: $(COMPANY)" >> $@
	@echo "Copyright: $(COPYRIGHT)" >> $@
	@echo "Build-Date: "`date` >> $@
	@echo "Build-Host: "`hostname` >> $@
	@echo "Build-User: $(USER)" >> $@
	@echo "Build-Option: $(MODE) $(DEFINES)" >> $@
	@echo "Build-Id: $(BUILDNUM)" >> $@
	@printf "Class-Path: $(patsubst %, %.jar\n,$(USEJAR))  ../res\n\n\n" >> $@

# Jar archive
$(TARGETFILE): $(OBJDIR)/$(MODNAME).Manifest $(RESFILES) $(JAREXTLIBLINKS)
	@$(ABS_PRINT_info) "Building archive $@ ..."
	@mkdir -p $(TARGETDIR)
ifeq ($(ISWINDOWS),true)
	@$(call writeToBuildLogs,$(JAR) cf $@ -C $(JARIMGDIR) .)
	@$(JAR) cf `cygpath -m $@` -C `cygpath -m $(JARIMGDIR)` .
else
ifeq ($(JAR),dx)
	@$(call writeToBuildLogs,$(JAR) --dex --output $@ $(JARIMGDIR))
	@$(JAR) --dex --output $@ $(JARIMGDIR)
else
	@$(call writeToBuildLogs,$(JAR) cf $@ -C $(JARIMGDIR) .)
	@$(JAR) cf $@ -C $(JARIMGDIR) .
endif
endif
	@$(call writeToBuildLogs,$(JAR) umf $(OBJDIR)/$(MODNAME).Manifest $@)
ifeq ($(ISWINDOWS),true)
	@$(JAR) umf `cygpath -m $(OBJDIR)/$(MODNAME).Manifest` `cygpath -m $@`
else
ifneq ($(JAR),dx)
	@$(JAR) umf $(OBJDIR)/$(MODNAME).Manifest $@
endif
endif

# ---------------------------------------------------------------------
#  dependences beetween modules
# ---------------------------------------------------------------------
# used module jar is generated by running make from the module's path
$(TARGETDIR)/$(DOMAIN).$(APPNAME).%-$(VERSION).jar: $(PRJROOT)/%/Makefile
	make -C $(<D)

# used module jar is generated by running make from the module's path
$(TARGETDIR)/$(DOMAIN).$(APPNAME).%-$(VERSION).jar: ../%/Makefile
	make -C $(<D)

# ---------------------------------------------------------------------
# Run & debug rules
# ---------------------------------------------------------------------
run:: all
ifeq ($(ISWINDOWS),true)
	$(JAVA) -cp "$(CLASSPATH);$(shell cygpath -m $(TARGETFILE))" $(MAINCLASS) $(RUNARGS)
else
	$(JAVA) -cp "$(CLASSPATH):$(TARGETFILE)" $(MAINCLASS) $(RUNARGS)
endif

debug:: all
	$(JDB) -classpath "$(CLASSPATH)$(PATH_SEP)$(TARGETFILE)" -sourcepath src $(MAINCLASS) $(RUNARGS)

ifneq ($(INCTESTS),)
  include $(ABSROOT)/core/module-junit.mk
endif

show-java-classpath:
	@echo $(CLASSPATH)

show-java-srcpath:
	@echo "src:$(JARIMGDIR):$(JGENSRCDIR)"
