## 
## ---------------------------------------------------------------------
## JUnit services
## 
## Java test services variables:
## 
##  - JUNIT: junit package name (default is junit-4.8.2)
##  - TARGS: run only test class with name containing the string given with this variable.
JUNIT?=junit|4.8.2
JUNITXML?=junitXmlFormatter|0.0

JUNIT_JAR_FILE=$(ABS_CACHE)/noarch/$(subst |,-,$(JUNIT)).jar
JUNITXML_JAR_FILE=$(ABS_CACHE)/noarch/$(subst |,-,$(JUNITXML)).jar

TXTXSL=xunit2txt.xsl
TESTCLASSFILES=$(patsubst %.java,$(OBJDIR)/%.class,$(shell find test -name "Test*.java" 2>/dev/null))
TESTCLASSES:=$(subst /,.,$(patsubst $(OBJDIR)/test/%.class,test/%,$(TESTCLASSFILES)))
ifneq ($(TARGS),)
  # emulate +f argument feature from ccpunint abs integration to filter the tests to run
  # very basic for now, supports only one entry behind +f
  # TODO: better way should be to implement feature at test runner level.
  TESTCLASSES:=$(foreach tc,$(TESTCLASSES),$(if $(findstring $(filter-out +f,$(TARGS)),$(tc)),$(tc),))
endif
ifeq ($(ISWINDOWS),true)
TESTCLASSPATH=$(shell cygpath -mp '$(OBJDIR):$(JARIMGDIR):$(JUNIT_JAR_FILE):$(JUNITXML_JAR_FILE)$(CLASSPATH)
JUFLAGS=-classpath "$(TESTCLASSPATH)" -d "$(shell cygpath -m '$(OBJDIR)')" -sourcepath "$(shell cygpath -mp '.:src:$(OBJDIR)')"
else
TESTCLASSPATH=$(OBJDIR):$(JARIMGDIR):$(JUNIT_JAR_FILE):$(JUNITXML_JAR_FILE):$(CLASSPATH)
JUFLAGS=-classpath "$(TESTCLASSPATH)" -d $(OBJDIR) -sourcepath ".:src:$(OBJDIR)"
endif

$(OBJDIR)/test/%.class: test/%.java
	@$(ABS_PRINT_info) "Compiling test class $< ..."
	@mkdir -p $(OBJDIR)
	@$(call writeToBuildLogs,$(JC) $(JUFLAGS) $<)
	@$(JC) $(JUFLAGS) $< || ( echo 'Failed: JUFLAGS=$(JUFLAGS)' ; exit 1 )

$(OBJDIR)/test/%.class: src/test/%.java
	@$(ABS_PRINT_info) "Compiling test class $< ..."
	@mkdir -p $(OBJDIR)
	@$(call writeToBuildLogs,$(JC) $(JUFLAGS) $<)
	@$(JC) $(JUFLAGS) $< || ( echo 'Failed: JUFLAGS=$(JUFLAGS)' ; exit 1 )

$(TESTCLASSFILES): $(ABS_CACHE)/noarch/$(call getLibNameFromVersioned,$(JUNIT))/$(call getLibVersionFromVersioned,$(JUNIT))/pck.jar $(ABS_CACHE)/noarch/$(call getLibNameFromVersioned,$(JUNITXML))/$(call getLibVersionFromVersioned,$(JUNITXML))/pck.jar $(TARGETFILE)

## 
## Targets:
## 
##  - check: run all tests
##  - test: run all tests
ifeq ($(wildcard test),)
test:: $(TARGETFILE)
else
test:: $(TESTCLASSFILES)
	@$(ABS_PRINT_info) "check : running tests $(TESTCLASSFILES)"
	@mkdir -p $(TTARGETDIR)
	@rm -f $(TEST_REPORT_PATH)
ifeq ($(ISWINDOWS),true)
	TRDIR="$(shell cygpath -m '$(TRDIR)')" TTARGETDIR="$(shell cygpath -m '$(TTARGETDIR)')" $(JAVA) -cp "$(TESTCLASSPATH)"\
     -Dorg.schmant.task.junit4.target="$(shell cygpath -m '$(TEST_REPORT_PATH)')" $(TOPTS)\
     barrypitman.junitXmlFormatter.Runner $(TESTCLASSES)\
     2>&1 | tee $(TTARGETDIR)/$(APPNAME)_$(MODNAME).stdout  || true
else
	@TRDIR="$(TRDIR)" TTARGETDIR="$(TTARGETDIR)" $(JAVA) -cp "$(TESTCLASSPATH)"\
     -Dorg.schmant.task.junit4.target=$(TEST_REPORT_PATH) $(TOPTS)\
     barrypitman.junitXmlFormatter.Runner $(TESTCLASSES)\
     2>&1 | tee $(TTARGETDIR)/$(APPNAME)_$(MODNAME).stdout  || true
endif
	@if [ ! -r $(TEST_REPORT_PATH) ]; then $(ABS_PRINT_error) "no test report, test runner exited abnormally."; \
	else xsltproc $(ABSROOT)/core/$(TXTXSL) $(TEST_REPORT_PATH); fi
endif

##  - <TestClassName>: run tests define in test class defined in
##    test/<TestClassName>.java
Test%: $(OBJDIR)/test/Test%.class
	@$(ABS_PRINT_info) "Test% : running test $@"
	@$(JAVA) -cp "$(TESTCLASSPATH)" org.junit.runner.JUnitCore test.$@


##  - newtest <name of class to be tested>: create a new test source file in
##      the test directory.
ifeq ($(word 1,$(MAKECMDGOALS)),newtest)
TESTNAME=$(word 2,$(MAKECMDGOALS))$(T)
.PHONY: newtest
newtest:
	@$(ABS_PRINT_info) "generating Junit test class test/Test$(TESTNAME).java to test $(TESTNAME) class."
	@mkdir -p test
	@test -f test/Test$(TESTNAME).java || printf "package test;\n\
import org.junit.*;\n\
import static org.junit.Assert.*;\n\
import $(DOMAIN).$(APPNAME).$(MODNAME).$(TESTNAME);\n\
\n\
/**\n\
 *\n\
 */\n\
public class Test$(TESTNAME) {\n\
    /**\n\
     * Pre-test initialisations.\n\
     */\n\
    @Before public void setUp() {\n\
    }\n\
    /**\n\
     * Post-test finalizations.\n\
     */\n\
    @After public void tearDown() {\n\
    }\n\
\n\
    /**\n\
     *\n\
     */\n\
    @Test public void test() {\n\
    }\n\
}\n\
" > test/Test$(TESTNAME).java

$(TESTNAME):
	@:


endif
