# ---------------------------------------------------------------------
# Rust Cargo management
# ---------------------------------------------------------------------
ifeq ($(MODE),release)
CARGO_OPTS+=--release
endif

RUST_EDITION?=2021

# Cargo.toml to permit the use of dev tools to find sources (or to compile via Cargo tool).
CARGO_TOML=$(MODROOT)/Cargo.toml
CARGO_TOML_TEMPLATE=$(MODROOT)/Cargo_template.toml

RUST_TARGET_DIR=$(OBJDIR)/target
RUST_CARGO_EXECUTED=$(OBJDIR)/cargo.executed
RUST_EXTLIB_WITH_RSFILES=$(patsubst $(EXTLIBDIR)/%/src/lib.rs,%,$(foreach lib,$(USELIB_FOR_PATH),$(wildcard $(EXTLIBDIR)/$(lib)/src/*/src/lib.rs)))

RUST_DEPENDS_TEXT=$(subst $(SPACE) ,\n,$(foreach mod,$(USEMOD),$(mod)={path=\"../$(mod)\"}) $(foreach extlib,$(RUST_EXTLIB_WITH_RSFILES),$(lastword $(subst /, ,$(extlib)))={path=\"$(EXTLIBDIR)/$(extlib)\"}))
RUST_DEPENDS_OUT_TEXT=$(subst $(SPACE) ,\n,$(foreach mod,$(USEMOD),$(mod)={path=\"../$(mod)\"}) $(foreach extlib,$(RUST_EXTLIB_WITH_RSFILES),$(lastword $(subst /, ,$(extlib)))={path=\"../../../$(extlib)\"}))

# RUST_BIN_DIR => directory of rust binaries
RUST_BIN_DIR?=
RUST_CARGO_CMD=CARGO_TARGET_DIR=$(RUST_TARGET_DIR) $(RUST_BIN_DIR)cargo

$(RUST_CARGO_EXECUTED): $(RUSTSRCFILES) $(CARGO_TOML) $(PRJOBJDIR)/$(MODNAME)/.depready $(foreach mod,$(USEMOD),$(wildcard $(TRDIR)/lib/lib$(USEMOD).rlib))
	@mkdir -p $(@D)
	@$(RUST_CARGO_CMD) build $(CARGO_OPTS)
	@touch $@

run:: $(RUST_TARGET_FILE_BIN)
	@$(RUST_TARGET_FILE_BIN)

test:: $(RUST_CARGO_EXECUTED)
	@$(RUST_CARGO_CMD) test $(CARGO_OPTS) $(T)

$(RUST_TARGET_FILE_BIN): $(RUST_CARGO_EXECUTED)
	@mkdir -p $(@D)
	@$(ABS_PRINT_info) "Copy generated binary to $@"
	@cp $(RUST_TARGET_DIR)/$(MODE)/$(MODNAME)$(TARGET_EXT) $@

$(RUST_TARGET_FILE_RLIB): $(RUST_CARGO_EXECUTED)
	@mkdir -p $(@D)
	@$(ABS_PRINT_info) "Copy generated rlib to $@"
	@cp $(RUST_TARGET_DIR)/$(MODE)/lib$(MODNAME).rlib $@

$(RUST_TARGET_FILE_SO): $(RUST_CARGO_EXECUTED)
	@mkdir -p $(@D)
	@$(ABS_PRINT_info) "Copy generated dynamic lib to $@"
	@cp $(RUST_TARGET_DIR)/$(MODE)/lib$(MODNAME)$(SOEXT) $@

#remove a-zA-Z from VERSION because version must be MAJOR.MINOR.PATCH in rust.
$(CARGO_TOML): $(CARGO_TOML_TEMPLATE) module.cfg $(PRJROOT)/app.cfg
	@echo "# File generated by module-rust.mk. Must not be modified manually" > $@.tmp
	@echo "# This file is regenerated at each compilation." >> $@.tmp
	@VERSION=`echo $(VERSION) | sed 's/[a-zA-Z]//g'` && \
		grep -E -v "^#.*" $< | \
		sed -e "s/@VERSION@/$$VERSION/g" \
		    -e "s~@DEPENDENCIES@~$(RUST_DEPENDS_TEXT)~g" \
			-e "s/@RUST_EDITION@/$(RUST_EDITION)/g" \
			-e "s/@CREATE_TYPE@/$(subst $(_space_),$(_comma_),$(patsubst %,'%',$(CRATETYPE)))/g" \
			>> $@.tmp
	@chmod +w $@
	@chmod -w $@.tmp
	@mv $@.tmp $@

.ONESHELL:
$(CARGO_TOML_TEMPLATE):
	@cat << EOF > $@
		# File generated by module-rust.mk
		# Can be modified to add dependencies or other elements.
		# Variable with @ are replaced during compilation.
		[package]
		name = "$(MODNAME)"
		version = "@VERSION@"
		edition = '@RUST_EDITION@'
		[lib]
		crate-type = [@CREATE_TYPE@]
		[dependencies]
		EOF
	@echo "@DEPENDENCIES@" >> $@

